
<?PHP

	//********************************************************************************
	//If you should have any comments, suggestions or improvements to these samples,
	//we welcome you to contact us at SampleCode@melissadata.com also please visit our
	//developers bulletin board at forum.melissadata.com.
	//********************************************************************************

	// ********************** LICENSE STRINGS ***********************
	// *     To unlock the full function ality of Address Object,    *
	// * please call a sales representative at 1-800-MELISSA ext. 3 *
	// *         (1-800-635-4772 x3) for a license string.          *
	// *      Without a valid license string, AddressCheck will     *
	// *                only verify Nevada addresses.               *
	// **************************************************************
	$dLICENSE = "DEMO";

	// ********************** DATA FILE PATH  ***********************
	// File location path is set to the default Data File location. *
	// Change this value if you installed the data files to a       *
	// different folder.                                            *
	// The Data Files Directory must contain the following files:   *
	// mdAddr.dat, mdAddr.lic, mdAddr.nat, and mdAddr.str           *
	// **************************************************************
	$dFILELOC= "C:\\Program Files\\Melissa DATA\\DQT\\Data";

	//Create the objects.
	$cBuff = "";   //Buffer to hold output comment data
	$addrObj = new COM("AddressObject.AddressCheck") or die("Cannot start for you");
	$zipObj = new COM("AddressObject.ZipCodeData") or die("Cannot start for you");
	$streetObj = new COM("AddressObject.StreetData") or die("Cannot start for you");
	$parseObj = new COM("AddressObject.Parse") or die("Cannot start for you");

//Call these subs when necessary to initialize objects
function  addrObjInit(){
	global $addrObj;
	global $dLICENSE;
	global $dFILELOC;

	$addrObj->SetLicenseString($dLICENSE);
	
	$addrObj->PathToUSFiles=($dFILELOC);
	
	//CASS required add-ons for highest level of validation. Should be used by non-demo users.
	//$addrObj->PathToDPVDataFiles=($dFILELOC);			  //DPV Add-on
	//$addrObj->PathToLACSLinkDataFiles=($dFILELOC);	//LACS Link Add-on
	//$addrObj->PathToSuiteLinkDataFiles=($dFILELOC);	//Suite Link Add-on
	
	
	//$addrObj->PathToCanadaFiles=($dFILELOC);			    //Canadian Add-on
	//$addrObj->PathToRBDIFiles=($dFILELOC);				    //Delivery Indicator Add-on (Residence or Business)
	//$addrObj->PathToSuiteFinderDataFiles=($dFILELOC);	//AddressPlus Add-on (appends residential suites)
	
	$addrObj->InitializeDataFiles();
}

function streetObjInit(){
	global $streetObj;
	global $dLICENSE;
	global $dFILELOC;

	$streetObj->SetLicenseString($dLICENSE);
	if ($streetObj->Initialize($dFILELOC, $dFILELOC ,"")) {
		echo 'Error Initializing streetObj';
	}
}

function zipObjInit(){
	global $zipObj;
	global $dLICENSE;
	global $dFILELOC;

	$zipObj->SetLicenseString($dLICENSE);
	if ($zipObj->Initialize($dFILELOC  ,$dFILELOC  )){
		echo 'Error Initializing zipObj';
	}
}

function parseObjInit(){
	global $parseObj;
	global $dFILELOC;
	$parseObj->Initialize($dFILELOC );
}



//Call these subs when printing output to screen
function printParseProperties(){
	global $parseObj;
	global $cBuff;

	$lineEnd="";
	if ($_POST["bsubmit"]=="Reparse") {
		$lineEnd=" ";
	}
	else {
		$lineEnd="\r\n";
	}

	$cBuff =$cBuff ."Rnge=".$parseObj->Range.$lineEnd;
	$cBuff =$cBuff ."PreDir=".$parseObj->PreDirection.$lineEnd;
	$cBuff =$cBuff ."StrtName=".$parseObj->StreetName.$lineEnd;
	$cBuff =$cBuff ."Suf=".$parseObj->Suffix.$lineEnd;
	$cBuff =$cBuff ."PostDir=".$parseObj->PostDirection.$lineEnd;
	$cBuff =$cBuff ."SteName=".$parseObj->SuiteName.$lineEnd;
	$cBuff =$cBuff ."SteNum=".$parseObj->SuiteNumber.$lineEnd;
	//$cBuff =$cBuff ."PMName=".$parseObj->PrivateMailboxName.$lineEnd;
	//$cBuff =$cBuff ."PMNum=".$parseObj->PrivateMailboxNumber.$lineEnd;
	$cBuff =$cBuff ."Grbg=".$parseObj->Garbage."\r\n";


}

function printStreetProperties(){

	global $streetObj;
	global $cBuff;

	//Filling and formating comment form with initial results.
	$cBuff =$cBuff .$streetObj->PrimaryRangeLow."-";
	$cBuff =$cBuff .$streetObj->PrimaryRangeHigh." ";
	$cBuff =$cBuff .$streetObj->PrimaryRangeOddEven." ";
	$cBuff =$cBuff .$streetObj->PreDirection." ";
	$cBuff =$cBuff .$streetObj->StreetName." ";
	$cBuff =$cBuff .$streetObj->Suffix." ";
	$cBuff =$cBuff .$streetObj->PostDirection." ";
	If (!($streetObj->SuiteName=="")) {
		$cBuff =$cBuff .$streetObj->SuiteName." ";
	}
	else{
		$cBuff =$cBuff ."     ";
	}
	If (!($streetObj->SuiteRangeLow=="")){
		$cBuff =$cBuff .trim($streetObj->SuiteRangeLow)."-";
	}
	else{
		$cBuff =$cBuff ."  ";
	}
	If (! ($streetObj->SuiteRangeHigh=="")) {
		$cBuff =$cBuff .trim($streetObj->SuiteRangeHigh)." ";
	}
	else{
		$cBuff =$cBuff ." ";
	}
	$cBuff =$cBuff .$streetObj->SuiteRangeOddEven." ";
	$cBuff =$cBuff .$streetObj->Zip." ";
	$cBuff =$cBuff .$streetObj->Plus4Low."-";
	$cBuff =$cBuff .$streetObj->Plus4High."\r\n";
}
function printZipProperties(){

	global $zipObj;
	global $cBuff;

	$cBuff =$cBuff .$zipObj->Zip." ";
	$cBuff =$cBuff .$zipObj->City." ";
	$cBuff =$cBuff .$zipObj->State." ";
	$cBuff =$cBuff .$zipObj->AreaCode." ";
	$cBuff =$cBuff .$zipObj->CountyFips." ";
	$cBuff =$cBuff .$zipObj->CountyName." ";
	$cBuff =$cBuff .$zipObj->Latitude." ";
	$cBuff =$cBuff .$zipObj->Longitude." ";
	$cBuff =$cBuff .$zipObj->LastLineIndicator."\r\n";
}
?>
<HTML>
	<HEAD>
		<META http-equiv='Content-Language' content='en-us'>
		<META http-equiv='Content-Type' content='text/html charset=UTF-8'>
		<META http-equiv='ImageToolbar' content='no'>

		<META name='Author' content='Melissa Data Corporation'>
		<META name='Description' content='AddressObject: PHP Sample Code.'>

		<TITLE>AddressObject: PHP Sample Code</TITLE>



<?PHP
	//Using PHP:
	//Setting page variables and clearing them.
	$Build="----";
	$ExpDate="----";
	$DatabaseDate="----";
	$InitErrorString="----";
	$cCompany="";
	$cAddress ="";
	$cAddress2 ="";
	$cSuite ="";
	$cCity ="";
	$cState ="";
	$cZip ="";
	$cPlus4 ="";
	$Results="";
	$ResultsString="";
	$comments ="";

	//f-variables used to hold initial input info passed through pages.
	if(!empty($_POST)){
		$fCompany=$_POST["Company"];
		$fAddress=$_POST["Address"];
		$fAddress2 =$_POST["Address2"];
		$fCity =$_POST["City"];
		$fState =$_POST["State"];
		$fZip =$_POST["Zip"];
		$fPlus4 =$_POST["Plus4"];
		$fLastName =$_POST["LastName"];

	//If Verify button is pressed, run Verify Address.
	if ($_POST["bsubmit"] =="Verify"){
		//Loading form with database date, expiration date, Build, and initialization status.
		addrObjInit();
		$Build=$addrObj->GetBuildNumber();
		$DatabaseDate=$addrObj->GetUSDatabaseDate();
		$ExpDate=$addrObj->GetUSExpirationDate();
		$InitErrorString=$addrObj->GetInitializeErrorString();

    //clear any remaining properties from previous calls
    $addrObj->ClearProperties();

		//Loading values from Post into Object.
		$addrObj->Company=$_POST["Company"];
		$addrObj->Address=$_POST["Address"];
		$addrObj->Address2=$_POST["Address2"];
		$addrObj->City=$_POST["City"];
    		$addrObj->State = $_POST["State"];
    		$addrObj->Plus4 = $_POST["Plus4"];
		$addrObj->ZIP = $_POST["Zip"];
		$addrObj->LastName = $_POST["LastName"];

		//Verifying address. VerifyAddress() will return TRUE if successful.
		$addrObj->VerifyAddress();

		//Loading form with captured and corrected data.
		$cCompany=$addrObj->Company;
		$cAddress=$addrObj->Address;
		$cAddress2=$addrObj->Address2;
		$cSuite=$addrObj->Suite;
		$cCity=$addrObj->City;
		$cState=$addrObj->State;
		$cZip=$addrObj->Zip;
		$cPlus4=$addrObj->Plus4;

		//Loading form with Results, which replace deprecated status and error codes.
		$ResultsString=$addrObj->Results;
		if ((strstr($ResultsString,"AS01") != false) || (strstr($ResultsString,"AS02") != false) || (strstr($ResultsString,"AS03") != false))
		{
			 // address was verified
       if (strstr($ResultsString,"AS01") != false)
           $Results=$Results."AS01: Full Address Matched to Postal Database and is deliverable\r\n";
       elseif (strstr($ResultsString,"AS02") != false)
					  $Results=$Results."AS02: Address matched to USPS database but a suite was missing or invalid\r\n";
		elseif (strstr($ResultsString,"AS03")!= false)
     	  $Results=$Results."AS03: Valid Physical Address, not Serviced by the USPS \r\n";					  
    } 
      
    //  Display additional level of verification/comments 
	
    if (strstr($ResultsString,"AS09")!= false)
     	  $Results=$Results."AS09: Foreign Postal Code Detected \r\n";
    if (strstr($ResultsString,"AS10")!= false)
     	  $Results=$Results."AS10: Address Matched to CMRA\r\n";
    if (strstr($ResultsString,"AS13")!= false)
     	 $Results=$Results."AS13: Address has been Updated by LACSLink\r\n";
    if (strstr($ResultsString,"AS14")!= false)
     	  $Results=$Results."AS14: Suite Appended by SuiteLink\r\n";
    if (strstr($ResultsString,"AS15")!= false)
     	  $Results=$Results."AS15: Suite Appended by SuiteFinder\r\n";
    if (strstr($ResultsString,"AS16")!= false)
     	  $Results=$Results."AS16: Address is vacant.\r\n";
    if (strstr($ResultsString,"AS17")!= false)
     	  $Results=$Results."AS17: Alternate delivery.\r\n";
    if (strstr($ResultsString,"AS18")!= false)
         $Results=$Results."AS18: DPV processing was terminated artificially created adresses detected.\r\n";
    if (strstr($ResultsString,"AS20")!= false)
     	  $Results=$Results."AS20: Address Deliverable by USPS only \r\n";
    if (strstr($ResultsString,"AS21")!= false)
     	  $Results=$Results."AS21: Alternate Address Suggestion Found\r\n";
    if (strstr($ResultsString,"AS22")!= false)
         $Results=$Results."AS22: No Alternate Address Suggestion Found\r\n";
    if (strstr($ResultsString,"AS23")!= false)
     	  $Results=$Results."AS23: Extraneous information found \r\n";
    
    if (strstr($ResultsString,"AE")!= false) 
    {
       // there was an error in verifying the address
			 if (strstr($ResultsString,"AE01")!= false)
            $Results=$Results."AE01: Zip Code Error \r\n";
       if (strstr($ResultsString,"AE02")!= false)
        	  $Results=$Results."AE02: Unknown Street Error \r\n";
       if (strstr($ResultsString,"AE03")!= false)
        	  $Results=$Results."AE03: Component Mismatch Error \r\n";
       if (strstr($ResultsString,"AE04")!= false)
        	  $Results=$Results."AE04: Non-Deliverable Address Error \r\n";
       if (strstr($ResultsString,"AE05")!= false)
        	  $Results=$Results."AE05: Multiple Match Error \r\n";
       if (strstr($ResultsString,"AE06")!= false)
        	  $Results=$Results."AE06: Early Warning System Error \r\n";
       if (strstr($ResultsString,"AE07")!= false)
        	  $Results=$Results."AE07: Missing Minimum Address Input \r\n";
       if (strstr($ResultsString,"AE08")!= false)
        	  $Results=$Results."AE08: Suite Range Invalid Error\r\n";
       if (strstr($ResultsString,"AE09")!= false)            
        	  $Results=$Results."AE09: Suite Range Missing Error \r\n";
       if (strstr($ResultsString,"AE10")!= false)
        	  $Results=$Results."AE10: Primary Range Invalid Error \r\n";
       if (strstr($ResultsString,"AE11")!= false)
        	  $Results=$Results."AE11: Primary Range Missing Error \r\n";
       if (strstr($ResultsString,"AE12")!= false)
        	  $Results=$Results."AE12: PO, HC, or RR Box Number Invalid \r\n";
       if (strstr($ResultsString,"AE13")!= false)
        	  $Results=$Results."AE13: PO, HC, or RR Box Number Missing \r\n";
       if (strstr($ResultsString,"AE14")!= false)
        	  $Results=$Results."AE14: CMRA Secondary Missing Error\r\n";
            
       // program can not attempt address lookup 
       if (strstr($ResultsString,"AE15")!= false)
            $Results=$Results."AE15: Demo Mode [will only verify Nevada records]\r\n";
       if (strstr($ResultsString,"AE16")!= false)
            $Results=$Results."AE16: Expired Database, please update\r\n";
       
       if (strstr($ResultsString,"AE17")!= false)
        	  $Results=$Results."AE17: Unnecessary Suite Error \r\n";
       if (strstr($ResultsString,"AE19")!= false)
        	  $Results=$Results."AE19: Max time for FindSuggestion exceeded \r\n";
       if (strstr($ResultsString,"AE20")!= false)
        	  $Results=$Results."AE20: FindSuggestion cannot be used\r\n"; 
		}
		
		//  there was a change to the input
    if (strstr($ResultsString,"AC01")!= false)
     	  $Results=$Results."AC01: ZIP Code Change \r\n";
    if (strstr($ResultsString,"AC02")!= false)
     	  $Results=$Results."AC02: State Change\r\n";
    if (strstr($ResultsString,"AC03")!= false)
     	 $Results=$Results."AC03: City Change\r\n";
    if (strstr($ResultsString,"AC04")!= false)
     	  $Results=$Results."AC04: Base/Alternate Change\r\n";
    if (strstr($ResultsString,"AC05")!= false)
     	  $Results=$Results."AC05: Alias Name Change\r\n";
    if (strstr($ResultsString,"AC06")!= false)
     	  $Results=$Results."AC06: Address1/Address2 Swap\r\n";
    if (strstr($ResultsString,"AC07")!= false)
     	  $Results=$Results."AC07: Address1/Company Swap\r\n";
    if (strstr($ResultsString,"AC08")!= false)
         $Results=$Results."AC08: Plus4 Change\r\n";
    if (strstr($ResultsString,"AC09")!= false)
     	  $Results=$Results."AC09: Urbanization Change \r\n";
    if (strstr($ResultsString,"AC10")!= false)
     	  $Results=$Results."AC10: Street Name Change\r\n";
    if (strstr($ResultsString,"AC11")!= false)
         $Results=$Results."AC11: Street Suffix Change\r\n";
    if (strstr($ResultsString,"AC12")!= false)
     	  $Results=$Results."AC12: Street Directional Change \r\n";
    if (strstr($ResultsString,"AC13")!= false)
     	  $Results=$Results."AC13: Suite Name Change \r\n";

           
		//Loading the comment text field with extra data and flags that are set when
		//the VerifyAddress Method is called.
		$comments="CarrierRoute=".$addrObj->CarrierRoute . "\r\n";
		$comments=$comments."DeliveryPointCheckDigit=".$addrObj->DeliveryPointCheckDigit."\r\n";
		$comments=$comments."DeliveryPointCode=".$addrObj->DeliveryPointCode."\r\n";
		$comments=$comments."DPVFootnotes=".$addrObj->DPVFootnotes."\r\n";
		$comments=$comments."\r\n";
		$comments=$comments."AddressTypeCode=".$addrObj->AddressTypeCode."\r\n";
		$comments=$comments."AddressTypeString=".$addrObj->AddressTypeString."\r\n";
		$comments=$comments."CityAbbreviation=".$addrObj->CityAbbreviation."\r\n";
		$comments=$comments."CountyName=".$addrObj->CountyName."\r\n";
		$comments=$comments."CountyFips=".$addrObj->CountyFips."\r\n";
		$comments=$comments."CountryCode=".$addrObj->CountryCode."\r\n";
		$comments=$comments."CongressionalDistrict=".$addrObj->CongressionalDistrict."\r\n";
		$comments=$comments."TimeZone=".$addrObj->TimeZone."\r\n";
		$comments=$comments."TimeZoneCode=".$addrObj->TimeZoneCode."\r\n";
		$comments=$comments."Urbanization=".$addrObj->Urbanization."\r\n";
		$comments=$comments."Zip=".$addrObj->Zip."\r\n";
		$comments=$comments."ZipType=".$addrObj->ZipType."\r\n";
		$comments=$comments."\r\n";
		$comments=$comments."ParsedAddressRange=".$addrObj->ParsedAddressRange . "\r\n";
		$comments=$comments."ParsedPreDirection=".$addrObj->ParsedPreDirection. "\r\n";
		$comments=$comments."ParsedStreetName=".$addrObj->ParsedStreetName. "\r\n";
		$comments=$comments."ParsedSuffix=".$addrObj->ParsedSuffix. "\r\n";
		$comments=$comments."ParsedSuiteName=".$addrObj->ParsedSuiteName. "\r\n";
		$comments=$comments."ParsedSuiteRange=".$addrObj->ParsedSuiteRange. "\r\n";
		$comments=$comments."ParsedPostDirection=".$addrObj->ParsedPostDirection. "\r\n";
		$comments=$comments."ParsedPrivateMailboxName=".$addrObj->ParsedPrivateMailboxName. "\r\n";
		$comments=$comments."ParsedPrivateMailboxNumber=".$addrObj->ParsedPrivateMailboxNumber. "\r\n";
		$comments=$comments."ParsedGarbage=".$addrObj->ParsedGarbage."\r\n";
		$comments=$comments."\r\n";
		$comments=$comments."MSA=".$addrObj->MSA."\r\n"	;
		$comments=$comments."PMSA=".$addrObj->PMSA."\r\n";
		$comments=$comments."CMRA=".$addrObj->CMRA."\r\n";
		$comments=$comments."PrivateMailbox=".$addrObj->PrivateMailbox."\r\n";
		$comments=$comments."\r\n";				
		$comments=$comments."ELotOrder=".$addrObj->ELotOrder."\r\n";
		$comments=$comments."ELotNumber=".$addrObj->ELotNumber."\r\n";
		$comments=$comments."LACS=".$addrObj->LACS."\r\n" ;
		$comments=$comments."LACSLinkIndicator=".$addrObj->LACSLinkIndicator."\r\n";
		$comments=$comments."LACSLinkReturnCode=".$addrObj->LACSLinkReturnCode."\r\n";
		$comments=$comments."SuiteLinkReturnCode=".$addrObj->SuiteLinkReturnCode."\r\n";
		$comments=$comments."EWS=".$addrObj->EWSFlag."\r\n";
		$comments=$comments."RBDI=".$addrObj->RBDI."\r\n";
				
	}
	//If Parse button is pressed, run parse routine.
	elseif($_POST["bsubmit"]=="Parse") {

		//Get $Build info.
		parseObjInit();
		$Build=$parseObj->GetBuildNumber();

		//Calling Parse(), the first parsing of the address text from
		//Must be run before ParseNext().
		$parseObj->Parse($_POST["Address"]);

		//Filling comment field with captured parsed data.
		$cBuff ="Parsing this string: ".$_POST["Address"]."\r\n";
		printParseProperties();
		$comments=$cBuff ;

	// If Reparse button is pressed, run reparse routine.
	// Because PHP can! pass com objects through pages, reparse loop is
	// completed in one page.
	}
	elseif($_POST["bsubmit"]=="Reparse") {

		parseObjInit();
		$Build=$parseObj->GetBuildNumber();

		//Calling Parse(), the first parsing of the address text from Form
		//Must be run before ParseNext().
		$parseObj->Parse($_POST["Address"]);

		//Filling comment field with captured parsed data.
		$cBuff ="Parsing this string: ".$_POST["Address"]."\r\n";
		printParseProperties();

		//Now looping ParseNext until it runs out of token combinations.
		while($parseObj->ParseNext()){
			//Filling comment field with captured parsed data.
			printParseProperties();
		}

		$cBuff =$cBuff ."Finished Re-parsing";
		$comments=$cBuff;
	}
	//If Parse Last Line is selected, run parse last routine.
	elseif($_POST["bsubmit"]=="Parse Last Line") {
		//Loading $parseObj
		parseObjInit();
		$Build=$parseObj->GetBuildNumber();

		//This implementation parses the COMBINED string taken from City,State,
		// Zip and Plus4.  To test, feel free to enter entire CITY,STATE AND ZIP into City Field
		$parseObj->LastLineParse($_POST["City"]." ".$_POST["State"]." ".$_POST["Zip"]." ".$_POST["Plus4"]);

		//Filling comment field with captured parsed data.
		$comments="Parsing this string: '".$_POST["City"]." ".$_POST["State"]." ".$_POST["Zip"]." ".$_POST["Plus4"]."'";
		$comments=$comments."\r\n"."City=".$parseObj->City."\r\n";
		$comments=$comments."State=".$parseObj->State."\r\n";
		$comments=$comments."Zip=".$parseObj->Zip."\r\n";
		$comments=$comments."Plus4=".$parseObj->Plus4."\r\n";
	}

	//If Find Street is selected, run find street routine.
	elseif($_POST["bsubmit"]=="Find Street") {
		streetObjInit();
		//Loading form with database date, expiration date, $Build, and initialization status.
		$Build=$streetObj->GetBuildNumber();
		$DatabaseDate=$streetObj->GetDatabaseDate();
		$InitErrorString=$streetObj->GetInitializeErrorString();

		//Loading Parse Object to hold parsed full address.
		parseObjInit();
		//Parsing Address value once to obtain only the Street Name and storing result.
		$parseObj->Parse($_POST["Address"]);
		//Creating variable to hold only the parsed StreetName.
		$pStreet=$parseObj->StreetName;

		//Calling and testing FindStreet() to find the first street range found with input data.
		//FindStreet() Returns FALSE is no street record is found.
		if ( $streetObj->FindStreet($pStreet,$_POST["Zip"],"0")==0) {
			//FindStreet() did ! find the specified street in the zip code, show warning.
			//Check if your street in address is spelled correctly.  If you have reparsed manually, it may
			//have scrambled the input address so it would ! be recognized by FindStreet().
			echo "<script language=JavaScript>";
			echo 'alert("Unable to locate specific Street Name in Zip Code.")</script>';

		}
		else{
			//Sucessful, recognized street and zip.
			//Clear buff and print properties
			$cBuff ="";
			printStreetProperties();

			//Now will loop to try to find the next data.  Loop exits when FALSE.
			//FindStreetNext() returns TRUE if next record exists
			while($streetObj->FindStreetNext()){
				//Filling comment form with next result.
				printStreetProperties();
			}
			$comments=$cBuff;
		}

	}
	//Option to find Cities in States with values from form
	//Wild card * values can be used for City value.
	elseif($_POST["bsubmit"]=="City in State") {
		//Steps to Initialize $zipObj
		zipObjInit();
		//Loading form with database date, expiration date, $Build, and initialization status.
		$Build=$zipObj->GetBuildNumber();
		$DatabaseDate=$zipObj->GetDatabaseDate();
		$InitErrorString=$zipObj->GetInitializeErrorString();

		//Call and test FindCityInState() to find first city in specified state.
		//FindCityInState() returns true if record is found.
		if($zipObj->FindCityInState($_POST["City"],$_POST["State"])) {
			//Successful.  Filling comment form with initial results.
			$comments =$zipObj->City." ";
			$comments=$comments.$zipObj->State."\r\n";

			//Now will loop to try to find the next data.  Loop exits when FALSE.
			//FindCityinStateNext() returns TRUE if next record exists.
			while($zipObj->FindCityInStateNext()){
				//Filling comment form with next result.
				$comments=$comments.$zipObj->City." ";
				$comments=$comments.$zipObj->State."\r\n";
			}
		}
		else{
			//Not successful, display warning.
			echo "<script language=JavaScript>";
			echo 'alert("Unable to find City in State.")</script>';


		}
	}
	//If Zip in City button is selected, run zip in city routine.
	elseif($_POST["bsubmit"]=="Zip in City") {
		//Steps to Initialize $zipObj
		//Loading $zipObj

		zipObjInit();

		//Loading form with database date, expiration date, $Build, and initialization status.
		$Build=$zipObj->GetBuildNumber();
		$DatabaseDate=$zipObj->GetDatabaseDate();
		$InitErrorString=$zipObj->GetInitializeErrorString();

		//Call and test ZipInCity() to find first zip code in specified city and state.
		//ZipInCity() returns true if record is found.
		if($zipObj->FindZipInCity($_POST["City"],$_POST["State"])) {
			//Successful.  Filling comment form with initial results.
			$$cBuff  ="";
			printZipProperties();
			//Now will loop to try to find the next data.  Loop exits when FALSE.
			//FindZipInCityNext() returns TRUE if next record exists.
			while($zipObj->FindZipInCityNext()){
				//Filling comment form with next result.
				printZipProperties();
			}
			$comments=$cBuff;
		}
		else{
			//Not successful, display warning.
			echo "<script language=JavaScript>";
			echo 'alert("Unable to find Zip in City/State.")</script>';


		}
	}
	//Option to find the Cities/States associated with a specified zip.
	elseif($_POST["bsubmit"]=="Find Zip") {

		//Steps to Initialize $zipObj
		//Loading $zipObj

		zipObjInit();
		//Loading form with database date, expiration date, $Build, and initialization status.
		$Build=$zipObj->GetBuildNumber();
		$DatabaseDate=$zipObj->GetDatabaseDate();
		$InitErrorString=$zipObj->GetInitializeErrorString();

		//Call and test FindZip() to find first zip code in specified city and state.
		//FindZip() returns true if record is found.
		if($zipObj->FindZip($_POST["Zip"],0)) {
			//Successful.  Creating header for output.
			//Filling comment form with initial results.
			$cBuff  ="";
			printZipProperties();
			//Now will loop to try to find the next data.  Loop exits when FALSE.
			//FindZipNext() returns TRUE if next record exists.
			while($zipObj->FindZipNext()){
				//Filling comment form with next result.
				//Filling comment form with next result.
				printZipProperties();
			}
			$comments=$cBuff;
		}
		else{
			//Not successful, display warning.
			echo "<script language=JavaScript>";
			echo 'alert("Unable to locate Zip Code.")</script>';

		}
	}
	//All other options failed, meaning the page is initially loaded, so loading
	//input fields with default information.
}
	else{
		$fCompany="ABC Company";
		$fAddress="201 10th St.";
		$fAddress2="";
		$fCity="Las Vegas";
		$fState="NV";
		$fZip="89101";
		$fPlus4="";
		$fLastName="";
	}

?>

</HEAD>



<body>

		<TABLE border='0' cellpadding='0' cellspacing='0' width='744'>
			<TR>
				<TD background='background.gif' height='59'>
					<a href='http:'www.melissadata.com'><img border='0' src='melissadata.gif' width='218' height='21'>
				</TD>
			</TR>
			<TR style='font-family:arial;font-size:110%;color:white'>
				<TD align='center' background='background.gif' colspan='4' height='30'><B>AddressObject: PHP Sample Code</B></TD>
			</TR>
		</TABLE>

		<FORM method='post' action="">
			<TABLE width='744' style='font-family:arial;font-size:80%'>
				<TR><TD></TD></TR>
				<TR><TD Colspan='2'><B>Database Status:</b></TD></TR>
				<TR>
					<TD Colspan='2'style='font-family:arial;font-size:7.8pt;color:gray'>
						Build: <INPUT type='text' name='Build' size='13' value='<?php echo  $Build ?>' disabled>
						Database Date: <INPUT type='text' name='DatabaseDate' size='7' value='<?php echo  $DatabaseDate?>' disabled>
						Exp. Date: <INPUT type='text' name='ExpDate' size='7' value='<?php echo  $ExpDate?>' disabled>
					</td>
				</TR>
				<TR>
					<Td colspan='2' style='font-family:arial;font-size:7.8pt;color:gray'>
						<align='right'>Init. Error String: <INPUT type='text' name='InitErrorString' size='50' value='<?php echo  $InitErrorString?>' disabled></TD>
					</td>
				</tr>
				<TR>
					<TD colspan='1'><B>Input:</B></TD>
					<TD colspan='1'><B>Address Verifcation:</B></TD>
				</TR>
				<TR>
					<td>
						<TABLE width='350'  style='font-family:arial;font-size:7.8pt'>
							<TR>
								<TD align='right'><b>Company:</b></TD>
								<TD><INPUT type='text' name='Company' size='35' value='<?php echo  $fCompany ?>'></TD>
							</TR>
							<TR>
								<TD align='right'><b>Address:</b></TD>
								<TD><INPUT type='text' name='Address' size='35' value='<?php echo  $fAddress?>'></TD>
							</TR>
							<TR>
								<TD align='right'></TD>
								<TD><INPUT type='text' name='Address2' size='35' value='<?php echo  $fAddress2?>'></TD>
							</tr>
							<tr>
								<TD align='right'><b>City:</b></TD>
								<TD><INPUT type='text' name='City' size='21' value='<?php echo  $fCity ?>'>  <b>State:</b> <INPUT type='text' name='State' size='2' value='<?php echo  $fState?>'></TD>
							</tr>
							<tr>
								<TD align='right'><b>Zip:</b></TD>
								<TD><INPUT type='text' name='Zip' size='2' value='<?php echo  $fZip?>'>  <b> - </b> <INPUT type='text' name='Plus4' size='1' value='<?php echo  $fPlus4?>'>
								<b>Last Name:</b><INPUT type='text' name='LastName' size='12' value='<?php echo  $fLastName?>'></td>
							</tr>
							<tr>
								<TD align='right'>Address</td>
								<TD><INPUT type='submit' name='bsubmit' value='Verify'></td>
							</tr>
							<tr>
								<TD align='right'>Parse</td>
								<TD><INPUT type='submit' name='bsubmit'value='Parse' onclick=''><INPUT type='submit' name='bsubmit' value='Reparse'><INPUT type='submit' name='bsubmit' value='Parse Last Line'></td>
							</tr>

							<tr>
								<TD align='right'>Street</td>
								<TD><INPUT type='submit' name='bsubmit' value='Find Street'></td>
							</tr>
							<tr>
								<TD align='right'>Zip</td>
								<TD><INPUT type='submit' name='bsubmit' value='City in State'><INPUT type='submit' name='bsubmit' value='Zip in City'><INPUT type='submit' name='bsubmit' value='Find Zip'></td>
							</tr>
						</TD></TR></TABLE>
					</td>
					<td valign='top'>
						<TABLE width='350' style='font-family:arial;font-size:7.8pt;color:gray'>
						<TR>
							<TD align='right'>Company:</TD>
							<TD  colspan='2'><INPUT type='text' name='cCompany' size='24' value='<?php echo  $cCompany?>' disabled></TD>
						</TR>
						<TR>
							<TD align='right'>Address:</TD>
							<TD><INPUT type='text' name='cAddress' size='24' value='<?php echo  $cAddress?>' disabled></TD>
						</TR>
						<TR>
							<TD align='right'>Address2:</TD>
							<TD><INPUT type='text' name='cAddress2' size='24' value='<?php echo  $cAddress2?>' disabled></TD>
							<TD></tD>
						<TR>
							<TD align='right'>Suite:</TD>
							<TD><INPUT type='text' name='cSuite' size='24' value='<?php echo  $cSuite?>' disabled></TD>
						</TR>
						<tr>
							<TD align='right'>City:</TD>
							<TD><INPUT type='text' name='cCity' size='24' value='<?php echo  $cCity?>' disabled></TD>
							<TD></TD>
						</tr>
						<tr>
							<TD align='right'>State:</TD>
							<TD colspan='2'><INPUT type='text' name='cState' size='1' value='<?php echo  $cState?>' disabled> Zip: <INPUT type='text' name='cZip' size='2' value='<?php echo  $cZip?>' disabled> - <INPUT type='text' name='cPlus4' size='1' value='<?php echo  $cPlus4?>' disabled></td>
						</tr>
						<tr>
							<td align='right'>Results:</td>
							<TD><textarea rows="8" cols="50" name='Results'  style='font-family:arial;font-size:10pt;color:blue'><?php echo  $Results?></textarea></TD>
						</tr>
						</table>
					</td>
				</tr>
				<tr>
					<TD colspan='1'><B>Other Data:</B></td>
					<TD colspan='1'><B></B></TD>
				</tr>
				<tr>
					<td colspan='2' align='center'>
						<textarea name="$comments" cols="90" rows="15" style='font-size:10 pt'><?php echo  $comments?></textarea>
					</td>
				</tr>
				<tr>
				</tr>
				<tr>
				</tr>
				<tr>
				</tr>
			</TABLE>

		</FORM>

</body>